(defmeth scatterplot-proto :add-regression-color-lines ()
"Adds regression lines for points with colors"
  (let* (
         ;(line? (send self :add-linear))
         (visible (which (mapcar #'(lambda (s) (not (equal s 'invisible))) 
                                   (send self :point-state (iseq (send self :num-points))))))
         (x (send self :point-coordinate (first (send self :current-variables)) visible))
                          
         (y (send self :point-coordinate (second (send self :current-variables)) visible))
         (var-colors (send self :point-color visible))
         (colors (remove-duplicates var-colors :test #'equal))
         (points-in-color (mapcar #'(lambda (c) (which (mapcar #'(lambda (p) (equal c p)) var-colors))) colors))
         )

    (mapcar #'(lambda (pincolor c)
                (cond 
                  ((= (length pincolor) 1)
                   nil)
                  ((= (length pincolor) 2)
                   (send self :add-lines (select x pincolor) (select y pincolor) :color c))
                  (t 
                   (let* ((c c)
                          (rg-coef (send (regression-model (select x pincolor) 
                                                           (select y pincolor) :print nil) :coef-estimates))
                          
                          (xs (list (min (select x pincolor)) (max (select x pincolor))))
                          (fullxs (list (list (min x) (first xs)) (list (second xs) (max x))))
                          (ys (mapcar #'(lambda (xx) (+ (first rg-coef) (* (second rg-coef) xx))) xs))
                          
                          (fullys (mapcar #'(lambda (fxs)
                                              (mapcar #'(lambda (xx) 
                                                          (+ (first rg-coef) (* (second rg-coef) xx))) fxs))
                                          fullxs)))
                     (send self :add-lines (send self :make-high-d-lines xs ys) :color c )
                     (mapcar #'(lambda (fx fy) (send self :add-lines (send self :make-high-d-lines fx fy) :color c :type 'dashed )) fullxs fullys)
                     ))
                ))
            points-in-color colors)

))


(defmeth scatterplot-proto :add-lines-by-selections (selections)
  "Args: selections is a list of selections. To be used for creating the figure of coplot brushing.Not finished."
 
(let* (
         ;(line? (send self :add-linear))
         (visible (which (mapcar #'(lambda (s) (not (equal s 'invisible))) 
                                   (send self :point-state (iseq (send self :num-points))))))
         (x (send self :point-coordinate (first (send self :current-variables)) visible))
                          
         (y (send self :point-coordinate (second (send self :current-variables)) visible))
       (var-colors (send self :point-color visible))
       (colors (select (list 'yellow 'orange 'red 'brown 'violet 'black) (iseq (length selections))))
        ; (points-in-color (mapcar #'(lambda (c) (which (mapcar #'(lambda (p) (equal c p)) var-colors))) colors))
       (selections selections)
         )

    (mapcar #'(lambda (pincolor c)
                (cond 
                  ((and (variancep x) (variancep y))
                   nil)
                  ((= (length pincolor) 1)
                   nil)
                  ((= (length pincolor) 2)
                   (send self :add-lines (select x pincolor) (select y pincolor) :color c))
                  (t 
                   (let* ((c c)
                          (rg-coef (send (regression-model (select x pincolor) 
                                                           (select y pincolor) :print nil) :coef-estimates))
                          
                          (xs (list (min (select x pincolor)) (max (select x pincolor))))
                          (fullxs (list (list (min x) (first xs)) (list (second xs) (max x))))
                          (ys (mapcar #'(lambda (xx) (+ (first rg-coef) (* (second rg-coef) xx))) xs))
                          
                          (fullys (mapcar #'(lambda (fxs)
                                              (mapcar #'(lambda (xx) 
                                                          (+ (first rg-coef) (* (second rg-coef) xx))) fxs))
                                          fullxs)))
                     (send self :add-lines (send self :make-high-d-lines xs ys) :color c )
                     (mapcar #'(lambda (fx fy) (send self :add-lines (send self :make-high-d-lines fx fy) :color c :type 'dashed )) fullxs fullys)
                     ))
                ))
            selections colors)

))

(defmeth scatterplot-proto :deactive-hilited-lines ()
	(send self :clear-curves)
  (defmeth self :adjust-screen ()
    (call-next-method)))

(defmeth scatterplot-proto :activate-hilited-lines ()
  (defmeth self :adjust-screen ()
    ;(call-next-method)
    (send self :add-hilited-lines))

  (defmeth self :add-hilited-lines ()
	
 
    (setf hilited  (which (mapcar #'(lambda (s) (or (equal s 'hilited) (equal s 'selected)) )
                                  (send self :point-state (iseq (send self :num-points))))))
    (send self :start-buffering)
    (send self :clear-curves)
    (when hilited
          (let* ((visible (which (mapcar #'(lambda (s) (not (equal s 'invisible))) 
                                         (send self :point-state (iseq (send self :num-points))))))
                 (x (send self :point-coordinate (first (send self :current-variables)) visible))
                 (y (send self :point-coordinate (second (send self :current-variables)) visible))
                 (c 'brown)
                 )
            
            (cond ((= (length hilited) 1)
                   )
              ((= (length hilited) 2)
               (send self :add-lines (select x hilited) (select y hilited) :color c))
              ((not (and (variancep (select x hilited)) (variancep (select y hilited))))
               )
              (t 
               (let* ((c c)
                      (rg-coef (send (regression-model (select x hilited) 
                                                       (select y hilited) :print nil) :coef-estimates))
                      
                      (xs (list (min (select x hilited)) (max (select x hilited))))
                      (fullxs (list (list (min x) (first xs)) (list (second xs) (max x))))
                      ; (rr (print xs))
                      (ys (mapcar #'(lambda (xx) (+ (first rg-coef) (* (second rg-coef) xx))) xs))
                      
                      (fullys (mapcar #'(lambda (fxs)
                                          (mapcar #'(lambda (xx) 
                                                      (+ (first rg-coef) (* (second rg-coef) xx))) fxs))
                                      fullxs)))
                 (send self :add-lines (send self :make-high-d-lines xs ys) :color c )
                 (mapcar #'(lambda (fx fy) (send self :add-lines (send self :make-high-d-lines fx fy) 
                                                 :color c :type 'dashed )) fullxs fullys)
               )))))
    (send self :buffer-to-screen)
    )
	(send self :add-hilited-lines)
	
  )

    


(defmeth scatterplot-proto :add-lowess-color-lines
  (&key (color 'red) (width 1))
"Keyword Args: (COLOR 'RED) (WIDTH 1)
Adds Lowess function to plot. The slot LOWESS-FRACTION must be spefified prior to useing this method."
  (send self :low-args `(:color ,color :width ,width))
  (let* ((cur-var (send self :current-variables))
         (npts (send self :num-points))
         (varx (send self :point-coordinate (first cur-var) (iseq npts)))
         (vary (send self :point-coordinate (second cur-var) (iseq npts)))
         ;(lxy (lowess varx vary :f (send self :lowess-fraction)))
         ;(xy (send self :make-high-d-lines (first lxy) (second lxy)))
         (overlay (first (send self :slot-value 'overlays)))
         (visible (which (mapcar #'(lambda (s) (not (equal s 'invisible))) 
                                   (send self :point-state (iseq (send self :num-points))))))
         (x (send self :point-coordinate (first (send self :current-variables)) visible))
                          
         (y (send self :point-coordinate (second (send self :current-variables)) visible))
         (var-colors (send self :point-color visible))
         (colors (remove-duplicates var-colors :test #'equal))
         (points-in-color (mapcar #'(lambda (c) (which (mapcar #'(lambda (p) (equal c p)) var-colors))) colors))
         )
    (if overlay
        (setf color-on? (and (send overlay :color-mode) (> *color-mode* 0)))
        (setf color-on? (> *color-mode* 0)))

   (mapcar #'(lambda (pincolor c)
                (cond 
                  ((= (length pincolor) 1)
                   nil)
                  ((= (length pincolor) 2)
                   (send self :add-lines (select x pincolor) (select y pincolor) :color c))
                  (t 
                   (let* ((lxy (lowess (select x pincolor) (select y pincolor) :f (send self :lowess-fraction)))
                          (xy (send self :make-high-d-lines (first lxy) (second lxy))))
                    
                   (send self :add-lines xy
                         :color (if color-on? c 'black) :width width)))))
                   points-in-color colors))
  t)



(defmeth scatterplot-proto :focus-on-selection ()
  (call-next-method)
  
  (send self :clear-curves)
  (send self :adjust-to-data))
                  
(defmeth scatterplot-proto :erase-selection ()
  (call-next-method)
  (send self :clear-curves)
  (send self :adjust-to-data))

(defmeth scatterplot-proto :show-all-points ()
  (call-next-method)
  (send self :clear-curves)
  (send self :adjust-to-data)
  )

#|(defmeth scatterplot-proto :set-selection-color ()
  (call-next-method)
  (send self :clear-curves))|#



;(send *current-plot* :add-regression-color-lines)
;(send *current-plot* :add-lowess-color-lines)
;(send *current-plot* :ask-save-pdf)
